package com.tykj.datawarehouse.model.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tykj.datawarehouse.base.result.ApiException;
import com.tykj.datawarehouse.model.dao.ColumnInfoDao;
import com.tykj.datawarehouse.model.dao.TableInfoDao;
import com.tykj.datawarehouse.model.entity.ColumnInfo;
import com.tykj.datawarehouse.model.entity.TableInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static java.lang.String.format;

/**
 * @author C
 */
@Service
public class ModelHelper {

    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private ColumnInfoDao columnInfoDao;



    /**
     * 获取指定数据模型的json格式数据示例
     *
     * @param tableInfoId 指定id
     * @return json格式的数据示例
     */
    public String getJsonExample(Integer tableInfoId) {
        /* 你要放10个元素，10/0.75+1=14 */
        Map<String, Object> result = new HashMap<>();
        TableInfo tableInfo = tableInfoDao.findById(tableInfoId)
                .orElseThrow(() -> new ApiException(format("未找到该id的数据:%s", tableInfoId)));
        String resultKey = tableInfo.getModelName();
        Map<String, Object> resultValue = new HashMap<>();
        //根据表id查出字段信息 并加入Map结果
        List<ColumnInfo> columnInfos = columnInfoDao.findAllByDbId(tableInfoId);
        for (ColumnInfo columnInfo : columnInfos) {
            resultValue.put(columnInfo.getFieldName(), null);
        }
        result.put(resultKey, resultValue);
        //做json转换并返回
        try {
            return new ObjectMapper().writeValueAsString(result);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new ApiException("json转换时出现异常");
        }
    }



}
