package com.tykj.datawarehouse.model.sqlType;

import java.util.HashMap;
import java.util.Map;

/**
 * @author HASEE
 */
public class OscarSqlType {

    /**
     * java类型对应sql类型Map
     */
    public static Map<String, String> TYPE_MAP = new HashMap<>();

    static {
        TYPE_MAP.put("java.lang.Integer", "int");
        TYPE_MAP.put("java.lang.Long", "bigint");
        TYPE_MAP.put("java.lang.Short", "smallint");
        TYPE_MAP.put("java.lang.Float", "float");
        TYPE_MAP.put("java.lang.Double", "DOUBLE PRECISION");
        TYPE_MAP.put("java.lang.BigDecimal", "numeric");
        TYPE_MAP.put("java.lang.Character", "char(1)");
        TYPE_MAP.put("java.lang.String", "varchar");
        TYPE_MAP.put("java.lang.Byte", "tinyint");
        TYPE_MAP.put("java.lang.Boolean", "BOOL");
        TYPE_MAP.put("java.lang.Class", "varchar");
        TYPE_MAP.put("java.util.Date", "date");
        TYPE_MAP.put("java.util.Calendar", "timestamp");
        TYPE_MAP.put("java.util.Locale", "varchar");
        TYPE_MAP.put("java.util.TimeZone", "varchar");
        TYPE_MAP.put("java.util.Currency", "varchar");
        TYPE_MAP.put("java.sql.Date", "date");
        TYPE_MAP.put("java.sql.Time", "time");
        TYPE_MAP.put("java.sql.Timestamp", "timestamp");
        TYPE_MAP.put("java.sql.Clob", "clob");
        TYPE_MAP.put("java.sql.Blob", "blob");
    }

}
