/*
 * Decompiled with CFR 0.152.
 */
package com.programmaticallyspeaking.aptdemo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import org.yaml.snakeyaml.Yaml;

public class YmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(YmlUtils.class);
    private static String bootstrap_file = "classpath:application.yml";
    private static Map<String, String> result = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getYmlByFileName(String filePath, String ... keys) {
        result = new HashMap<String, String>();
        if (filePath == null) {
            filePath = bootstrap_file;
        }
        InputStream in = null;
        try {
            File file = ResourceUtils.getFile((String)filePath);
            in = new BufferedInputStream(new FileInputStream(file));
            Yaml props = new Yaml();
            Object obj = props.loadAs(in, Map.class);
            Map param = (Map)obj;
            for (Map.Entry entry : param.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (keys.length != 0 && !keys[0].equals(key)) continue;
                if (val instanceof Map) {
                    YmlUtils.forEachYaml(key, (Map)val, 1, keys);
                    continue;
                }
                result.put(key, val.toString());
            }
            Map<String, String> map = result;
            return map;
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String getValue(String key) throws FileNotFoundException {
        Map<String, String> map = YmlUtils.getYmlByFileName(null, new String[0]);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static Map<String, String> forEachYaml(String key_str, Map<String, Object> obj, int i, String ... keys) {
        for (Map.Entry<String, Object> entry : obj.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (keys.length > i && !keys[i].equals(key)) continue;
            String str_new = "";
            str_new = StringUtils.isNotEmpty((CharSequence)key_str) ? key_str + "." + key : key;
            if (val instanceof Map) {
                YmlUtils.forEachYaml(str_new, (Map)val, ++i, keys);
                --i;
                continue;
            }
            result.put(str_new, val.toString());
        }
        return result;
    }

    public static String getApplicationName() throws FileNotFoundException {
        return YmlUtils.getYmlByFileName(bootstrap_file, new String[0]).get("server.port");
    }

    public static String getApplicationName1() throws FileNotFoundException {
        String name = YmlUtils.getYmlByFileName(bootstrap_file, new String[0]).get("spring.application.name");
        return name + "center";
    }

    public static void main(String[] args) throws FileNotFoundException {
        Map<String, String> ymlByFileName = YmlUtils.getYmlByFileName(bootstrap_file, "spring");
        Set<Map.Entry<String, String>> entries = ymlByFileName.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (!entry.getKey().equals("spring.datasource.driver-class-name") || !entry.getValue().contains("com.mysql.cj.jdbc.Driver") && !entry.getValue().contains("com.mysql.jdbc.Driver")) continue;
            System.out.println(111);
        }
    }
}

