package com.tykj.base.config;

import com.tykj.model.create_util.BaseCreateUtil;
import com.tykj.model.create_util.MysqlCreateTableUtil;
import com.tykj.model.create_util.OscarCreateUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * @author huangjiafu
 * @version V1.0
 * @data 2021/7/15 10:46
 **/
@Component
public class BeanFactory {
    @Value("${spring.datasource.driver-class-name}")
    private String env;

    @Bean("baseCreateUtil")
    BaseCreateUtil baseCreateUtil() {
        if ("com.mysql.cj.jdbc.Driver".equals(env) || "com.mysql.jdbc.Driver".equals(env)) {
            return new MysqlCreateTableUtil();
        }
//        if ("com.oscar.Driver".equals(env)) {
//            return new OscarCreateUtil();
//        }
        return new MysqlCreateTableUtil();
    }
}
