package com.tykj.base.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class BaseEntity
 * @packageName com.example.demo.entity
 **/
@Data
@MappedSuperclass
public abstract class BaseEntity {

    @Id
//    @SequenceGenerator(sequenceName = "SEQUENCE",name = "t1",allocationSize = 1)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    protected Integer id;

    @ApiModelProperty("创建时间")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm")
    protected Date createdTime;

    @ApiModelProperty("修改时间")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm")
    protected Date updatedTime;

    @ApiModelProperty("逻辑删除 0为 false 1为 true")
    protected Integer deleted = 0;

}
