package com.tykj.model.controller;


import com.tykj.base.result.ResultUtil;


import com.tykj.model.entity.Quote;
import com.tykj.model.entity.vo.SearchQuoteVO;
import com.tykj.model.entity.vo.UpdateQuoteVO;
import com.tykj.model.service.QuoteService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;


/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/5/17 15:57
 */

@Api(tags = "引用接口")
@RestController
@RequestMapping("/quote")
public class QuoteController {
    @Autowired
    private QuoteService quoteService;

    @ApiOperation("引用删除")
    @GetMapping("/delete")
    public ResponseEntity deleteQuote(Integer id) {
        Integer integer = quoteService.delQuote(id);
        if (integer==1){
            return ResultUtil.success("删除成功！");
        }
        return ResultUtil.failed("此id不存在，删除失败");
    }

    @ApiOperation("引用更新")
    @PostMapping("/update")
    public ResponseEntity UpdateQuote(@RequestBody UpdateQuoteVO updateQuoteVO) {
        int i = quoteService.updateQuote(updateQuoteVO);
        if (i==0){
            return ResultUtil.success( "更新/保存成功！");
        }
       return ResultUtil.failed( "引用数据重复，导致更新/保存失败！");
    }

    @ApiOperation("查找所有引用")
    @PostMapping("/getAllQuote")
    public ResponseEntity getAllQuote(@RequestBody SearchQuoteVO searchQuoteVO) {
        return ResultUtil.success(quoteService.getAllQuote(searchQuoteVO), "查询成功！");
    }

    @ApiOperation("保存引用")
    @PostMapping("/saveQuote")
    public ResponseEntity saveQuote(@RequestBody Quote quote) {
        return ResultUtil.success(quoteService.saveQuote(quote), "保存成功！");
    }

}
