/*
 * Decompiled with CFR 0.152.
 */
package com.programmaticallyspeaking.aptdemo;

import com.programmaticallyspeaking.aptdemo.Test;
import com.programmaticallyspeaking.aptdemo.YmlUtils;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.persistence.GenerationType;
import javax.persistence.Id;

@SupportedAnnotationTypes(value={"javax.persistence.*"})
public class AnnotationProcessor
extends AbstractProcessor {
    private Messager messager;
    private JavacTrees trees;
    private TreeMaker treeMaker;
    private Names names;
    Context context;
    private static String bootstrap_file = "application.yml";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.trees = JavacTrees.instance(processingEnv);
        this.context = ((JavacProcessingEnvironment)processingEnv).getContext();
        this.treeMaker = TreeMaker.instance(this.context);
        this.names = Names.instance(this.context);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(Id.class);
        set.forEach(element -> {
            JCTree jcTree = this.trees.getTree((Element)element);
            jcTree.accept(new TreeTranslator(){

                @Override
                public void visitVarDef(JCTree.JCVariableDecl jcVariableDecl) {
                    Map<String, String> ymlByFileName = YmlUtils.getYmlByFileName(new Test(bootstrap_file), "spring");
                    Set<Map.Entry<String, String>> entries = ymlByFileName.entrySet();
                    for (Map.Entry<String, String> entry : entries) {
                        if (entry.getKey().equals("spring.profiles.active")) {
                            String value = entry.getValue();
                            String fileName = "application-" + value + ".yml";
                            Map<String, String> ymlByFileName1 = YmlUtils.getYmlByFileName(new Test(fileName), "spring");
                            Set<Map.Entry<String, String>> entries1 = ymlByFileName1.entrySet();
                            for (Map.Entry<String, String> entry1 : entries1) {
                                if (!entry1.getKey().equals("spring.datasource.driver-class-name") || !entry1.getValue().contains("com.mysql.cj.jdbc.Driver")) continue;
                                JCTree.JCAnnotation jcAnnotation = AnnotationProcessor.this.mysqlId();
                                jcVariableDecl.mods.annotations = jcVariableDecl.mods.annotations.append(jcAnnotation);
                                super.visitVarDef(jcVariableDecl);
                            }
                            continue;
                        }
                        if (!entry.getKey().equals("spring.datasource.driver-class-name") || !entry.getValue().contains("com.mysql.cj.jdbc.Driver")) continue;
                        JCTree.JCAnnotation jcAnnotation = AnnotationProcessor.this.mysqlId();
                        jcVariableDecl.mods.annotations = jcVariableDecl.mods.annotations.append(jcAnnotation);
                        super.visitVarDef(jcVariableDecl);
                    }
                }
            });
        });
        return true;
    }

    private JCTree.JCAnnotation makeGetterMethodDecl() {
        JCTree.JCExpression expression = this.chainDots("javax.persistence.SequenceGenerator".split("\\."));
        return this.treeMaker.Annotation(expression, List.of(this.makeArg("sequenceName", "SEQUENCE"), this.makeArg("name", "t1"), this.makeArg("allocationSize", 1)));
    }

    private JCTree.JCAnnotation mysqlId() {
        JCTree.JCExpression expression = this.chainDots("javax.persistence.GeneratedValue".split("\\."));
        return this.treeMaker.Annotation(expression, List.of(this.makeArg2("strategy", GenerationType.IDENTITY)));
    }

    public JCTree.JCExpression makeArg(String key, Object value) {
        JCTree.JCAssign arg = this.treeMaker.Assign(this.treeMaker.Ident(this.names.fromString(key)), this.treeMaker.Literal(value));
        return arg;
    }

    public JCTree.JCExpression makeArg2(String key, Object value) {
        Symtab instance = Symtab.instance(this.context);
        JCTree.JCExpression jcExpression = this.chainDots("javax.persistence.GenerationType".split("\\."));
        JCTree.JCFieldAccess e = null;
        e = this.treeMaker.Select(jcExpression, this.names.fromString("IDENTITY"));
        JCTree.JCAssign arg = this.treeMaker.Assign(this.treeMaker.Ident(this.names.fromString(key)), e);
        return arg;
    }

    public JCTree.JCExpression chainDots(String ... elems) {
        assert (elems != null);
        JCTree.JCExpression e = null;
        for (int i = 0; i < elems.length; ++i) {
            e = e == null ? this.treeMaker.Ident(this.names.fromString(elems[i])) : this.treeMaker.Select(e, this.names.fromString(elems[i]));
        }
        assert (e != null);
        return e;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

