package com.tykj.model.entity;


import com.tykj.base.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;

/**
 * @ClassName TableInfo
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:05
 * @Version 1.0
 */

@Entity
//@Table(name = "table_info")
@Table
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("表对象")
public class TableInfo extends BaseEntity {


    @ApiModelProperty("数据对象名，不能为空")
    @Column(nullable = false)
    private String modelName;

    @ApiModelProperty("表中文名，不能为空")
    @Column(nullable = false)
    private String modelTitle;

    @ApiModelProperty("详细描述")
    private String description;

    @Lob
    @ApiModelProperty("表对应hbm.xml")
    private String xml;

}
