# 今日学习计划-2020-04-03

1. [语言编译器和解释器](#id1)
2. [git的粗糙实现原理](#id2)
3. [merge和rebase的区别](#id1)
4. [能装多少水的循环和双指针解法](#id1)
5. [两数之和题1](#id1)
6. [两数之和题2](#id1)
7. [三数之和]

<h2 id = "id1">语言编译器和解释器</h2>

例如：Java，kotlin，scala, clojure 

上面列举的语言均属于半编译半解释型语言，通过编译器进行编译后，由JVM进行运行，通过JVM对底层的操作系统进行交互。

![半编译半解释型语言简图](./images/img 1.png)

<h2 id = "id2">git的粗糙实现原理</h2>

git：一个分布式项目版本控制工具

分布式基本原理：通过 remote add <origin> <url> 为本地仓库和远程仓库建立联系通过pull和push命令进行推送和更新

分布式粗糙流程图，如下：
![GIT分布式粗糙流程图](./images/img 2.jpg)
Git版本快照存储方式，如下：
![GIT版本快照存储方式](./images/img 3.jpg)
Git远程上传合并机制流程图，如下：
![Git远程上传合并机制流程图](./images/img 4.jpg)

# Git中merge和rebase的区别

在git中假如对两条分支进行merge命令，git会取两条分支的最后一个commit与两条分支中的最后一个公共分支进行合并
![Git合并示例图](./images/img 5.jpg)

rebase变基的命令,会将当前分支重新设置开始点.即将当前分支的提交 放入 被rebase的分支的后方.
![Git合并示例图](./images/img 6.jpg)

# 能装多少水的循环和双指针解法

### 题目

给你 n 个非负整数 a1，a2，...，an，每个数代表坐标中的一个点 (i, ai) 。在坐标内画 n 条垂直线，垂直线 i 的两个端点分别为 (i, ai) 和 (i, 0)。找出其中的两条线，使得它们与 x 轴共同构成的容器可以容纳最多的水。

输入垂直线代表输入数组 [1,8,6,2,5,4,8,3,7]。在此情况下，容器能够容纳水（表示为蓝色部分）的最大值为 49

如图所示

![题目示例图](./images/img 7.jpg)

解题思路1:对数组进行两层嵌套循环,计算出每两个线所能表示的最大面积,设置一个临时变量MaxArea对最大面积进行保存,每次计算出来的面积与MaxArea进行比对,其中取较大值为MaxArea赋值.

```java
    //通过循环的方式进行运算
    public static int maxArea(int[] height) {
        if (height.length < 2) {
            return 0;
        }
        int maxArea = 0;
        for (int i = 0; i < height.length; i++) {
            for (int j = i+1; j < height.length; j++) {
                maxArea = Math.max((j-i)*Math.min(height[j],height[i]),maxArea);
            }
        }
        return maxArea;
    }
```



第一次循环示例

![第一次循环示例](./images/img 8.jpg)

第二次循环示例

![第二次循环示例](./images/img 9.jpg)

最大面积示例

![最大面积示例](./images/img 10.jpg)

解题思路2:通过在数组的头和尾建立两个指针,并且建立变量MaxArea对计算出最大面积进行保存.每次循环对两枚指针所能代表的区域进行面积计算,对每次计算出的面积与最大面积进行比对,每次比对则保留较大的数值,计算完毕后将所代表数字较小的指针向内移动一位,直至两枚指针相遇.

```java 
//    通过双指针向内夹进的方式进行运算
    public static int maxArea(int[] height) {
        if (height.length < 2) {
            return 0;
        }
        int left = 0;
        int right = height.length-1;
        int maxArea = 0;
        while (left<right){
            maxArea = Math.max((right-left)*Math.min(height[left], height[right]),maxArea);
            if (height[left] < height[right]) {
                left++;
            }else {
                right--;
            }
        }
        return maxArea;
    }
```

第一次循环示例图

![最大面积示例](./images/img 11.jpg)

第二次循环示例图

![最大面积示例](./images/img 12.jpg)

第三次循环示例

![最大面积示例](./images/img 13.jpg)

# 两数之和

题目：给定一个整数数组 nums 和一个目标值 target，请你在该数组中找出和为目标值的那 两个 整数，并返回他们的数组下标。
你可以假设每种输入只会对应一个答案。但是，你不能重复利用这个数组中同样的元素。`printf()`

`给定 nums = [2, 7, 11, 15], target = 9
因为 nums[0] + nums[1] = 2 + 7 = 9
所以返回 [0, 1]
`



题目解法：

- 通过哈希表进行计算

```java
public static int[] twoSum(int[] nums, int target) {
        Map<Integer, Integer> map = new HashMap<>();
        for (int i = 0; i < nums.length; i++) {
            int complement = target - nums[i];
            if (map.containsKey(complement) ) {
                return new int[] { map.get(complement),i };
            }
            map.put(nums[i],i);
        }
        throw  new IllegalArgumentException("数据错误");
    }
```

该题利用了hashmap查询速度快且Key不能重复的特性，在对数组遍历的时候可以利用containsKey方法判断数组中是否存在目标数字，假如存在则 返回结果。





