# AOP

面向切面编程

### 实现方法：

写一个切面类，在类上使用注解@Aspect实现

给该类设计6个方法，分别使用6个注解：

①切入点：连接点，扫描到具体哪个包哪个类哪个方法

`@Pointcut("execution(public * com.kzj.kzj_rabbitmq.controller..*.*(..))")`

​				*execution(访问权限 返回类型 包名.类名.方法名(参数))*

②前置增强方法，相当于BeforeAdvice

`@Before("Pointcut()")`

③final增强，不管是抛出异常或者正常退出都会执行

`@After("Pointcut()")`

④后置增强，相当于AfterReturningAdvice，方法退出时执行

`@AfterReturning(value="Pointcut()",returning="result")`

⑤异常抛出增强，相当于ThrowsAdvice

`@AfterThrowing(value="Pointcut()",throwing="e")`

⑥环绕增强，相当于MethodInterceptor 

```
@Around("Pointcut()")
public Object Around(ProceedingJoinPoint pjp) throws Throwable {
    ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
    HttpServletRequest request = attributes.getRequest();	//获取http请求数据
    Object object = pjp.proceed();
    log.info("Request IP>>>"+request.getRemoteAddr()+"#######Response result>>>" +object);
    return object;
}
```

执行顺序：**@Around**===>**@Before**===>**方法调用**===>**@Around**===>**@After**===>**@AfterReturning**

​	

### 动态代理						