# Java对象合法性验证
在我们做Java Web 项目的时候，每个接口需要对前端传入的参数进行校验。而假如每一个接口都编写一段校验代码的话，会造成大量的代码冗余不利于项目的后期维护。
下面介绍几种最近学习到的代码统一验证的方法
1. 在SpringBoot中可以通过 @Valid 注解 搭配 统一错误处理类 实现对入参的校验
示例：
实体类
```Java
@Data
@Accessors(chain = true)
public static class User {
     @NotNull
     private String name;
     @Min(value = 20, message = "年龄需要大于20")
     private int age;
 }
```
其中 @NotNull 以及 @Min 分别起 属性不能为空 以及 设置属性最小值 的作用

Controller层
```Java
@GetMapping("/hello")
 public String test( @Valid User user) {
        throw new GlobalException("message");
 }
```
为需要验证合法性的入参添加 @Valid 注解

统一错误处理方法

```Java
@ControllerAdvice
public class GlobalExceptionHandler {

    /**
     * 描述：所有的报错信息都会通过这个方法处理并通过统一的返回方式进行返回
     *
     * @param e  报错信息
     * @Return : com.example.demo.entity.ResultObj
     * @Author : HuangXiahao
     * @Date : 2020/4/10 15:14
    */
    @ResponseBody
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(Exception.class)
    public ResultObj errorMessage(Exception e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),e.getMessage());
        return resultObj;
    }

    @ResponseBody
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(BindException.class)
    public ResultObj errorMessage(BindException e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),e.getAllErrors().get(0).getDefaultMessage());
        return resultObj;
    }

}
```

完成以上的设置后将能够在接口被调用的时候对入参进行合法性验证，若验证不通过程序会进入到统一错误处理类中并返回相应的提示信息