import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SnowflakeDemo {

    private final long sequenceLength = 12L;

    private final long workerIdLength = 10L;

    private final long lastTimeStampLength = 41L;

    private final long workerIdShift = sequenceLength;

    private final long lastTimeStampShift = sequenceLength + workerIdLength;

    private long lastTimeStamp = -1L;

    private long workerId;

    private long sequence = 0L;

    private long mark =  ~(-1L << sequenceLength);

    private static final int loopNum = 1*10000;

    public synchronized String getId() {
        long timeStamp = System.currentTimeMillis();
        if(timeStamp < lastTimeStamp) {
            throw new RuntimeException("time error");
        }

        if(timeStamp == lastTimeStamp) {
            sequence = (sequence + 1) & mark;
            if(sequence == 0) {
                while(timeStamp <= lastTimeStamp) {
                    timeStamp = System.currentTimeMillis();
                }
            }
        } else {
            sequence = 0;
        }
        lastTimeStamp = timeStamp;

        return Long.toBinaryString(sequence | (workerId << workerIdShift) | (timeStamp << lastTimeStampShift));
    }

    public synchronized long waitTime(long lastTimeStamp) {
        long timeStamp = System.currentTimeMillis();
        while(timeStamp <= lastTimeStamp) {
            timeStamp = System.currentTimeMillis();
        }
        return timeStamp;
    }

    private SnowflakeDemo(){}

    private SnowflakeDemo(long lastTimeStamp, long workerId, long sequence) {
        this.lastTimeStamp = lastTimeStamp;
        this.workerId = workerId;
        this.sequence = sequence;
    }

    public void m1() {
        ExecutorService pool = Executors.newCachedThreadPool();
        long currentTime = System.currentTimeMillis();
        SnowflakeDemo snowflakeDemo = new SnowflakeDemo(currentTime, 0, 0);
        for (int index = 0; index < loopNum; index++) {
            Runnable run = new Runnable() {
                public void run() {
                    try {
                        //new Thread().sleep(1000);  //模拟耗时操作
                        System.out.println("[1]" + Thread.currentThread().getName() + " " + snowflakeDemo.getId());
                    } catch (Exception e) {
                    }
                }
            };
            pool.execute(run);
        }
        System.out.println("[1] done!");
        pool.shutdown();
    }

    public static void main(String[] args) {
        long bt = System.currentTimeMillis();
        SnowflakeDemo snowflakeWorker0 = new SnowflakeDemo(bt, 0, 0);
        for(int i = 0; i < loopNum; i++) {
            System.out.println(snowflakeWorker0.getId());
        }
        long et = System.currentTimeMillis();
        System.out.println("耗时:"+(et2 - bt)+ "ms");
        System.out.println("吞吐量为："+loopNum*1.0/(et - bt));

        /*SnowflakeDemo TestThreadPool = new SnowflakeDemo();
        long bt = System.currentTimeMillis();
        TestThreadPool.m1();
        long et2 = System.currentTimeMillis();
        System.out.println("耗时:"+(et2 - bt)+ "ms");
        System.out.println("吞吐量为："+loopNum*1.0/(et2 - bt));*/

    }

}
