### **1. 数据库自增长序列或字段**

最常见的方式。利用数据库，全数据库唯一。

优点：

1）简单，代码方便，性能可以接受。

2）数字ID天然排序，对分页或者需要排序的结果很有帮助。

缺点：

1）不同数据库语法和实现不同，数据库迁移的时候或多数据库版本支持的时候需要处理。

2）在单个数据库或读写分离或一主多从的情况下，只有一个主库可以生成。有单点故障的风险。

3）在性能达不到要求的情况下，比较难于扩展。

4）如果遇见多个系统需要合并或者涉及到数据迁移会相当痛苦。

5）分表分库的时候会有麻烦。

优化方案：

1）针对主库单点，如果有多个Master库，则每个Master库设置的起始数字不一样，步长一样，可以是Master的个数。比如：Master1 生成的是 1，4，7，10，Master2生成的是2,5,8,11 Master3生成的是 3,6,9,12。这样就可以有效生成集群中的唯一ID，也可以大大降低ID生成数据库操作的负载。

 

### **2. UUID**

常见的方式。可以利用数据库也可以利用程序生成，一般来说全球唯一。

优点：

1）简单，代码方便。

2）生成ID性能非常好，基本不会有性能问题。

3）全球唯一，在遇见数据迁移，系统数据合并，或者数据库变更等情况下，可以从容应对。

缺点：

1）没有排序，无法保证趋势递增。

2）UUID往往是使用字符串存储，查询的效率比较低。

3）存储空间比较大，如果是海量数据库，就需要考虑存储量的问题。

4）传输数据量大

5）不可读。



### **3.snowflake算法 **

snowflake是Twitter开源的分布式ID生成算法。

**· 优点：**

1）不依赖于数据库，灵活方便，且性能优于数据库。

2）ID按照时间在单机上是递增的。

**· 缺点：**

1）在单机上是递增的，但是由于涉及到分布式环境，每台机器上的时钟不可能完全同步，也许有时候也会出现不是全局递增的情况。

2）存在时间回退问题，时间回退后，生成的ID就有可能重复。

**· ID结构：**

结果是一个long型的ID，分成四个部分：

0（符号位）—  000···000（41位表示毫秒数）—  000···000（10位表示机器的ID）—  000···000（12位作为序列号）

**· 原理：**

​			①设置一个初始对照时间戳*lastTime*，默认为0

​			②获取当前时间戳*currentTime*与*lastTime*比较，假如在同一毫秒内，序列号+1；假如								    *currentTime*>*lastTime*，重置序列号为0；假如*currentTime*<*lastTime*，说明时间倒退应该报错。

​			③若序列号达到最大值（12位全为1），则会触发等待直到下一毫秒，并将下一毫秒的时间戳作为*currentTime*

​			④将*lastTime*更新为*currentTime*作为对照时间戳

 · **关于如何解决时间回退问题：**

可以使用RingBuffer环形数组，预先生成一批ID，放在数组中。当低于阈值时触发数据填充。填充的时候时间戳为当前的时间戳。