# 能装多少水的循环和双指针解法

### 题目

给你 n 个非负整数 a1，a2，...，an，每个数代表坐标中的一个点 (i, ai) 。在坐标内画 n 条垂直线，垂直线 i 的两个端点分别为 (i, ai) 和 (i, 0)。找出其中的两条线，使得它们与 x 轴共同构成的容器可以容纳最多的水。

输入垂直线代表输入数组 [1,8,6,2,5,4,8,3,7]。在此情况下，容器能够容纳水（表示为蓝色部分）的最大值为 49

如图所示

![题目示例图](images/img7.jpg)

解题思路1:对数组进行两层嵌套循环,计算出每两个线所能表示的最大面积,设置一个临时变量MaxArea对最大面积进行保存,每次计算出来的面积与MaxArea进行比对,其中取较大值为MaxArea赋值.

```java
    //通过循环的方式进行运算
    public static int maxArea(int[] height) {
        if (height.length < 2) {
            return 0;
        }
        int maxArea = 0;
        for (int i = 0; i < height.length; i++) {
            for (int j = i+1; j < height.length; j++) {
                maxArea = Math.max((j-i)*Math.min(height[j],height[i]),maxArea);
            }
        }
        return maxArea;
    }
```



第一次循环示例

![第一次循环示例](images/img8.jpg)

第二次循环示例

![第二次循环示例](images/img9.jpg)

最大面积示例

![最大面积示例](images/img10.jpg)

解题思路2:通过在数组的头和尾建立两个指针,并且建立变量MaxArea对计算出最大面积进行保存.每次循环对两枚指针所能代表的区域进行面积计算,对每次计算出的面积与最大面积进行比对,每次比对则保留较大的数值,计算完毕后将所代表数字较小的指针向内移动一位,直至两枚指针相遇.

```java 
//    通过双指针向内夹进的方式进行运算
    public static int maxArea(int[] height) {
        if (height.length < 2) {
            return 0;
        }
        int left = 0;
        int right = height.length-1;
        int maxArea = 0;
        while (left<right){
            maxArea = Math.max((right-left)*Math.min(height[left], height[right]),maxArea);
            if (height[left] < height[right]) {
                left++;
            }else {
                right--;
            }
        }
        return maxArea;
    }
```

第一次循环示例图

![最大面积示例](images/img11.jpg)

第二次循环示例图

![最大面积示例](images/img12.jpg)

第三次循环示例

![最大面积示例](images/img13.jpg)