package api.thread.memory_barrier;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * 测试多线程数据不一致问题
 */
class ThreadDemo implements Runnable {
    //Solution1: volatile
    /*private volatile boolean flag = false;*/

    private boolean flag = false;	//flag初始化为false

    //Solution6: CAS
    /*private AtomicBoolean flag = new AtomicBoolean(false);*/

    @Override
    public void run() {	//将flag设置为true
        flag = true;

        /*flag.getAndSet(true);*/

        System.out.println("flag=" + flag);
    }

    public boolean isFlag() {
        return flag;
    }

    /*public AtomicBoolean isFlag() {
        return flag;
    }*/
}

/**
 * main
 */
class Main {

    public static void main(String[] args) {
        ThreadDemo threadDemo = new ThreadDemo();
        new Thread(threadDemo).start();	//启动线程threadDemo,线程中设置flag为true

        //Solution3: lock
        /*Lock lock = new ReentrantLock();
        lock.lock();*/
        while (true) {

            //Solution4: sleep()
            /*try {
                Thread.sleep(50);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }*/

            //Solution5: sout
            /*System.out.println("output here");*/

            //Solution2: synchronized
            /*synchronized (threadDemo) {*/
            if (threadDemo.isFlag()) {    //主线程中判断flag为true/false
                /*if (threadDemo.isFlag().get()) {*/
                System.out.println("----------------");
                break;
            }
            /*}*/
        }
        /*lock.unlock();*/
    }

}