## 异常统一处理

将会利用注解**@ExceptionHandler**

首先自定义异常类：

```
public class BaseException extends Exception {
    private int code;
    private String message;
    public BaseException(String message,int code){
        super();
        this.code = code;
        this.message = message;
    }
    public BaseException(String message,int code,Throwable e){
        super(message,e);
        this.message = message;
        this.code = code;
    }
}
```



第一种思路，设计一个基类：

```
public class BaseController {
    @ExceptionHandler
    @ResponseBody
    public Object expHandler(Exception e){
        if(e instanceof SystemException){
            BaseException baseException= (BaseException) e;
            return baseException.getMessage();
        }else{
            e.printStackTrace();
            return "请求错误";
        }
    }
}
```

之后所有需要异常处理的**Controller**都继承这个类，从而获取到异常处理的方法。



第二种思路，将上述基类写作接口，更加灵活



第三种思路，在**BaseController**上使用**@ControllerAdvice**注解，可以避免继承

