# 两数之和

题目：给定一个整数数组 nums 和一个目标值 target，请你在该数组中找出和为目标值的那 两个 整数，并返回他们的数组下标。
你可以假设每种输入只会对应一个答案。但是，你不能重复利用这个数组中同样的元素。`printf()`

`给定 nums = [2, 7, 11, 15], target = 9
因为 nums[0] + nums[1] = 2 + 7 = 9
所以返回 [0, 1]
`



题目解法：

- 通过哈希表进行计算

```java
public static int[] twoSum(int[] nums, int target) {
        Map<Integer, Integer> map = new HashMap<>();
        for (int i = 0; i < nums.length; i++) {
            int complement = target - nums[i];
            if (map.containsKey(complement) ) {
                return new int[] { map.get(complement),i };
            }
            map.put(nums[i],i);
        }
        throw  new IllegalArgumentException("数据错误");
    }
```

该题利用了hashmap查询速度快且Key不能重复的特性，在对数组遍历的时候可以利用containsKey方法判断数组中是否存在目标数字，假如存在则 返回结果。
