package com.example.personnelmanager.common.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class WebMvcConfig
 * @packageName com.example.personnelmanager.common.config
 * @data 2020/6/11
 **/

@Configuration
public class WebMvcConfig implements WebMvcConfigurer {

    @Value("${file.imagePath}")
    String imagePath;

    /**
     * 静态资源配置
     *
     * @param registry
     */
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/images/**").addResourceLocations("file:" + imagePath);
    }

}
