package com.example.personnelmanager.common.utils;

import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;

/**
 * 时间计算工具类
 *
 * @author HuangXiahao
 * @version V1.0
 * @class DateCalculationController
 * @packageName com.example.personnelmanager.common.utils
 * @data 2020/5/27
 **/
public class DateCalculationUtil {
    /***
     * 计算两个Instant之间相差的年份
     * 例如：1.2年
     * @param startTime
     * @param endTime
     * @Return : double
     * @Author : HuangXiahao
     * @Date : 2020/6/1 10:33
    */
    public static double twoTimeYearCalculation(Instant startTime,Instant endTime){
        LocalDateTime startLocalDateTime = LocalDateTime.ofEpochSecond(startTime.getEpochSecond(), 0, OffsetDateTime.now().getOffset());
        LocalDateTime endLocalDateTime = LocalDateTime.ofEpochSecond(endTime.getEpochSecond(), 0, OffsetDateTime.now().getOffset());
        int result = startLocalDateTime.get(ChronoField.MONTH_OF_YEAR) - endLocalDateTime.get(ChronoField.MONTH_OF_YEAR)/12;
//        int month = (startLocalDateTime.get(ChronoField.YEAR) - endLocalDateTime.get(ChronoField.YEAR)) * 12;
        int year = endLocalDateTime.get(ChronoField.YEAR) - (startLocalDateTime.get(ChronoField.YEAR) )  ;

//        return Double.parseDouble(new DecimalFormat("0.0").format(month+result));
        return year;
    }
}
