package com.example.personnelmanager.common.utils;

import lombok.extern.slf4j.Slf4j;
import sun.misc.BASE64Decoder;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @program: program
 * @description: 文件下载、解密、保存
 * @author: LiuJie
 * @create: 2019-07-02 15:13
 **/
@Slf4j
public class DownloadFile {

    private static String zhPattern = "[\u4E00-\u9FA5\\s+]";
//    private static String zhPattern = "[\\u4e00-\\u9fa5]";

    public static String encode(String str, String charset) throws UnsupportedEncodingException {
        Pattern p = Pattern.compile(zhPattern);
        Matcher m = p.matcher(str);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            String group = m.group(0);
            System.out.println("group:"+group);
            if (group.equals(" ")){
                m.appendReplacement(b, "%20");
            }else {
                m.appendReplacement(b, URLEncoder.encode(group, charset));
            }

//            m.appendReplacement(b, URLEncoder.encode(m.group(0), charset));
        }
        m.appendTail(b);
        return b.toString();
    }


    public static boolean getFile(String fileString, String fileName) {
        if (fileString == null) { // 图像数据为空
            return false;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            /**
             * 解码
             */
            byte[] b = decoder.decodeBuffer(fileString);
            for (int i = 0; i < b.length; ++i) {
                /**
                 * 调整异常数据
                 */
                if (b[i] < 0) {
                    b[i] += 256;
                }
            }
            /**
             * 生成文件路径
             */
            String filePath = "C:\\Users\\刘杰\\Desktop\\" + fileName;
            OutputStream out = new FileOutputStream(filePath);
            out.write(b);
            out.flush();
            out.close();
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }


    /**
     * @param urlPath 下载路径
     * @param saveDir 下载存放目录
     * @return 返回下载文件
     * @throws Exception
     */
    public static void downloadFile(String urlPath, String saveDir) throws Exception {
        URL url = new URL(urlPath);
        // 连接类的父类，抽象类
        URLConnection urlConnection = url.openConnection();
        // http的连接类
        HttpURLConnection httpURLConnection = (HttpURLConnection) urlConnection;
        // 设定请求的方法，默认是GET（对于知识库的附件服务器必须是GET，如果是POST会返回405。流程附件迁移功能里面必须是POST，有所区分。）
        httpURLConnection.setRequestMethod("GET");
        // 设置字符编码
        httpURLConnection.setRequestProperty("Charset", "UTF-8");
        // 打开到此 URL 引用的资源的通信链接（如果尚未建立这样的连接）。
//        int code = httpURLConnection.getResponseCode();
        InputStream inputStream = httpURLConnection.getInputStream();
        File file = new File(saveDir);
        OutputStream out = new FileOutputStream(file);
        int size = 0;
        int lent = 0;
        byte[] buf = new byte[1024];
        while ((size = inputStream.read(buf)) != -1) {
            lent += size;
            out.write(buf, 0, size);
        }
        inputStream.close();
        out.close();
    }

    /**
     * @param urlPath 下载路径
     * @param saveDir 下载存放目录
     * @return 返回下载文件
     * @throws Exception
     */
    public static void downloadFile(String urlPath, String saveDir,String name) throws Exception {
//        URL url = new URL(urlPath);
        String encode = encode(urlPath, "UTF-8");
        URL url = new URL(encode);
        // 连接类的父类，抽象类
        URLConnection urlConnection = url.openConnection();
        // http的连接类
        HttpURLConnection httpURLConnection = (HttpURLConnection) urlConnection;
        // 设定请求的方法，默认是GET（对于知识库的附件服务器必须是GET，如果是POST会返回405。流程附件迁移功能里面必须是POST，有所区分。）
        httpURLConnection.setRequestMethod("GET");
        // 设置字符编码
        httpURLConnection.setRequestProperty("Charset", "UTF-8");
        // 打开到此 URL 引用的资源的通信链接（如果尚未建立这样的连接）。
//        int code = httpURLConnection.getResponseCode();
        InputStream inputStream = httpURLConnection.getInputStream();
        Files.copy(inputStream, Paths.get(saveDir, name), StandardCopyOption.REPLACE_EXISTING);
        inputStream.close();
    }
}
