package com.example.personnelmanager.common.utils;

import sun.misc.BASE64Decoder;

import java.io.*;
import java.nio.file.Files;
import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

/**
 * @author bystander
 * @date 2018/9/30
 */
public class RsaUtils {

    /**
     * 从文件中读取公钥
     *
     * @param fileName
     * @return
     * @throws Exception
     */
    public static PublicKey getPublicKey(String fileName) throws Exception {
        String publicKey = readFile(fileName);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey.getBytes()));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePublic(spec);
    }

//    /**
//     * 从文件中读取私钥
//     *
//     * @param fileName
//     * @return
//     * @throws Exception
//     */
//    public static PrivateKey getPrivateKey(String fileName) throws Exception {
//        byte[] bytes = readFile(fileName);
//        return getPrivateKey(bytes);
//    }


    /**
     * 生成私钥
     *
     * @param bytes
     * @return
     * @throws Exception
     */
    public static PrivateKey getPrivateKey(byte[] bytes) throws Exception {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePrivate(spec);
    }

    /**
     * 读取文件
     *
     * @param fileName
     * @return
     * @throws IOException
     */
    public static String readFile(String fileName) throws Exception {
//        return Files.readAllBytes(new File(fileName).toPath());
        BufferedReader reader = new BufferedReader(new FileReader(new File(fileName)));
        String line;
        StringBuffer buffer = new StringBuffer("");
        while ((line=reader.readLine())!=null){
            buffer.append(line);
        }
        reader.close();
        return buffer.toString();

    }

    /**
     * 根据密文，生存rsa公钥和私钥,并写入指定文件
     *
     * @param publicKeyFilename  公钥文件路径
     * @param privateKeyFilename 私钥文件路径
     * @param secret             生成密钥的密文
     * @throws IOException
     * @throws NoSuchAlgorithmException
     */
    public static void generateKey(String publicKeyFilename, String privateKeyFilename, String secret) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom secureRandom = new SecureRandom(secret.getBytes());
        keyPairGenerator.initialize(1024, secureRandom);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        // 获取公钥并写出
        byte[] publicKeyBytes = keyPair.getPublic().getEncoded();
        writeFile(publicKeyFilename, publicKeyBytes);
        // 获取私钥并写出
        byte[] privateKeyBytes = keyPair.getPrivate().getEncoded();
        writeFile(privateKeyFilename, privateKeyBytes);
    }


    public static void test(String pubKeyStr) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        java.security.spec.X509EncodedKeySpec bobPubKeySpec = new java.security.spec.X509EncodedKeySpec(
                new BASE64Decoder().decodeBuffer(pubKeyStr));
        // RSA对称加密算法
        java.security.KeyFactory keyFactory;
        keyFactory = java.security.KeyFactory.getInstance("RSA");
        // 取公钥匙对象
        PublicKey publicKey = keyFactory.generatePublic(bobPubKeySpec);
        FileOutputStream fsPubkey = new FileOutputStream("G:/other/rsa.pub");
        fsPubkey.write(publicKey.getEncoded());
        fsPubkey.close();
    }

    /**
     * 向目标路径写入文件
     *
     * @param destPath
     * @param bytes
     * @throws IOException
     */
    public static void writeFile(String destPath, byte[] bytes) throws IOException {
        File dest = new File(destPath);
        if (!dest.exists()) {
            boolean newFile = dest.createNewFile();
            if (!newFile){
                throw new IOException("新建文件失败");
            }
        }
        Files.write(dest.toPath(), bytes);
    }
}
