package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.JobTransferInformation;
import com.example.personnelmanager.entity.PeoplePost;
import com.example.personnelmanager.entity.Post;
import com.example.personnelmanager.entity.commonEntity.ResultObj;
import com.example.personnelmanager.entity.vo.JobTranferVo;
import com.example.personnelmanager.service.JobTransferInformationService;
import com.example.personnelmanager.service.PeoplePostService;
import com.example.personnelmanager.service.PostService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeoplePostController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/22
 **/


@RestController
@RequestMapping("/api/peoplePost")
public class PeoplePostController {

    @Autowired
    PeoplePostService peoplePostService;

    @Autowired
    JobTransferInformationService jobTransferInformationService;

    @Autowired
    PostService postService;

    //为人员新增岗位
    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj addPeoplePost(@Validated(GroupSave.class) @RequestBody PeoplePost peoplePost){
        PeoplePost addPeoplePost = peoplePostService.addEntity(peoplePost);
        ResultObj resultObj = new ResultObj(addPeoplePost,addPeoplePost!=null?"success":"插入失败，出现未知的失败原因");
        return resultObj;
    }

    /***
     * 描述：人员换岗接口
     *
     * @param jobTranferVo 换岗所必须得属性
     * @Return : com.example.personnelmanager.entity.commnEntity.ResultObj
     * @Author : HuangXiahao
     * @Date : 2020/5/25 9:53
    */
    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    @Transactional
    public ResultObj updatePeoplePost(@Validated(GroupUpdate.class) @RequestBody JobTranferVo jobTranferVo){
        PeoplePost befor = peoplePostService.getOne(jobTranferVo.getPeoplePostId());
        if (befor==null){
            throw new GlobalException("原岗位记录不存在");
        }
        JobTransferInformation jobTransferInformation = new JobTransferInformation();
        jobTransferInformation.setBeforePost(befor.getPost());
        jobTransferInformation.setRemark(jobTranferVo.getRemark());
        jobTransferInformation.setPeople(befor.getPeople());
        //如果AfterPostId存在则为调岗，如果不存在则为离岗
        if (jobTranferVo.getAfterPostId()!=null){
            Post after = postService.getOne(jobTranferVo.getAfterPostId());
            if (after==null){
                throw new GlobalException("目标的岗位不存在");
            }
            befor.setPost(after);
            jobTransferInformation.setAfterPost(after);
            jobTransferInformationService.addEntity(jobTransferInformation);
            return new ResultObj(peoplePostService.update(befor),"success");
        }else {
            jobTransferInformationService.addEntity(jobTransferInformation);
            return new ResultObj(peoplePostService.delete(befor.getId()),"success");
        }
    }
}
