package com.example.personnelmanager.dao;

import com.example.personnelmanager.entity.People;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface PeopleRepository extends JpaRepository<People, Long>, JpaSpecificationExecutor {

    @Query("select p from People p where p.phone=:phone and p.enterprise.enterpriseId=:enterpriseId and p.peopleId<>:peopleId")
    List<People> findByPeopleIdAndPhoneAndEnterprise(Long peopleId,String phone,Long enterpriseId);

    @Query("select p from People p where p.phone=:phone and p.enterprise.enterpriseId=:enterpriseId ")
    List<People> findByPhoneAndEnterprise(String phone,Long enterpriseId);

}
