package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.Instant;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "education_image")
@ToString(exclude = {"educationalExperience"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class EducationImage {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "educational_image_id",columnDefinition = "bigint comment '教育经历照片编号' ")
  private Long educationalImageId;

  @Lob
  @Column(name = "url",columnDefinition = " text comment '教育经历照片地址'")
  private String url;

  @Column(name = "delete_tag",nullable = false,columnDefinition = " int default 0 comment '删除标记（0为正常，1为被删除）' ")
  private int deleteTag;

  @Column(name = "create_time",nullable = false,columnDefinition = " datetime comment '创建时间'")
  private Instant createTime;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional = false)
  @JoinColumn(name = "educational_id",nullable = false,columnDefinition = "bigint comment '教育经历编号'")
  private EducationalExperience educationalExperience;

}
