package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "educational_experience")
@ToString(exclude = {"people","enterprise"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class EducationalExperience {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "educational_id",columnDefinition = "bigint comment '合同照片编号' ")
  private Long educationalId;

  @Column(name = "qualifications",nullable = false,columnDefinition = "varchar(16) comment '学历(初中、高中、大专/高职、本科、硕士/MBA/EMBA、博士、其他)'")
  private String qualifications;

  @Column(name = "Graduation_school", columnDefinition = "varchar(128) comment '毕业院校' ")
  private String graduationSchool;

  @Column(name = "Graduation_date",columnDefinition = " datetime comment '毕业时间' ")
  private Instant graduationDate;

  @Column(name = "major",columnDefinition = "varchar(64) comment '所学专业'")
  private String major;

  @Column(name = "has_degree",columnDefinition = "bool comment '是否取得学位'")
  private Boolean hasDegree;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）'")
  private int deleteTag;

  @Column(name = "create_time",nullable = false,columnDefinition = "datetime comment '创建时间'")
  private Instant createTime;

  @Where(clause = "delete_tag = 0")
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "educationalExperience")
  private List<EducationImage> educationImages;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional = false)
  @JoinColumn(name = "people_id",columnDefinition = "bigint not null comment '人员编号'")
  private People people;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional=false)
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;

}
