package com.example.personnelmanager.entity;

import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import javax.validation.constraints.Max;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "enterprise")
@ToString(exclude = {"peoples","posts","workPlaces","organizationNodes","certificates","legalEntities","contracts","duties","educationalExperiences","titles","users"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class Enterprise implements Serializable {

  private static final long serialVersionUID = 1107313482047123539L;

  @Max(value = 0,message = "所属企业不允许被修改",groups = {GroupUpdate.class})
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "enterprise_id",columnDefinition = "bigint comment '企业编号' ")
  private Long enterpriseId;

  @Column(name = "enterprise_name",nullable = false,columnDefinition = "varchar(128) comment '企业名称'")
  private String enterpriseName;

  @Column(name = "enterprise_profession",columnDefinition = "varchar(64) comment '所属行业'")
  private String enterpriseProfession;

  @Column(name = "enterprise_province",columnDefinition = "varchar(16) comment '所在省份'")
  private String enterpriseProvince;

  @Column(name = "contact_name",columnDefinition = "varchar(64) comment '联系人姓名'")
  private String contactName;

  @Column(name = "contact_phone",columnDefinition = "varchar(16) comment '联系人电话'")
  private String contactPhone;

  @Column(name = "contact_mail",columnDefinition = "varchar(255) comment '联系人邮箱'")
  private String contactMail;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记'")
  private int deleteTag;

  @Column(name = "create_time",nullable = false,columnDefinition = " datetime comment '删除标记（0为正常，1为被删除）'")
  private Instant createTime;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<People> peoples;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<Post> posts;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<WorkPlace> workPlaces;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<OrganizationNode> organizationNodes;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<Certificate> certificates;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<LegalEntity> legalEntities;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<Contract> contracts;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<EducationalExperience> educationalExperiences;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<Title> titles;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "enterprise")
  private List<User> users;

}
