package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.Instant;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "leave_information")
@ToString(exclude = {"people"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class LeaveInformation {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "leave_id",columnDefinition = "bigint comment '企业编号' ")
  private Long leaveId;

  @Column(name = "leave_type",columnDefinition = "varchar(16) comment '离职类型(主动离职，被动离职，其他)' ")
  private String leaveType;

  @Column(name = "leave_time",nullable = false,columnDefinition = "datetime comment '离职时间' ")
  private Instant leaveTime;

  @Lob
  @Column(name = "leave_reason",nullable = false,columnDefinition = "text comment '离职原因' ")
  private String leaveReason;

  @Column(name = "last_work_time",columnDefinition = "datetime comment '最后工作日期' ")
  private Instant lastWorkTime;

  @Column(name = "apply_time",columnDefinition = "datetime comment '申请日期' ")
  private Instant applyTime;

  @Column(name = "pay_time",columnDefinition = "datetime comment '薪酬结算日期' ")
  private Instant payTime;

  @Lob
  @Column(name = "remark",columnDefinition = "text comment '备注' ")
  private String remark;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记'")
  private int deleteTag;

  @Column(name = "create_time",nullable = false,columnDefinition = " datetime comment '删除标记（0为正常，1为被删除）'")
  private Instant createTime;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH})
  @JoinColumn(name = "people_id",columnDefinition = "bigint comment '所属人员'")
  private People people;


}
