package com.example.personnelmanager.entity.vo;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：节点树状结构VO
 * @author HuangXiahao
 * @version V1.0
 * @class OrganizationNodeResponesListVo
 * @packageName com.example.personnelmanager.entity.vo
 * @data 2020/5/18
 **/
@Data
public class OrganizationNodeListVo  {

    public OrganizationNodeListVo(long nodeId, String nodeName, long parentNode, String nodeType) {
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.parentNode = parentNode;
        this.nodeType = nodeType;
    }

    private Long nodeId;

    private String nodeName;

    private Long parentNode;

    private String nodeType;

    private List<OrganizationNodeListVo> childeNodes = new ArrayList<>();

    public void addChildNode(OrganizationNodeListVo orgNodeVo) {
        childeNodes.add(orgNodeVo);
    }
}
