package com.example.personnelmanager.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;

import java.util.List;

/*
* 对于实体类进行操作的相关接口需要先实现该类获取增删改查等方法
* @param T 为服务层需要操作的实体
* @param S 为主键
* */
public interface BasicEntityService<T,S>  {

    T addEntity(T t);

    Page<T> getPage(T t, Pageable pageable);

    List<T> getList(T t);

    T update(T t);

    T getOne(S id);

    Boolean delete(S id);

    Specification<T> specificationBuild(T t);



}
