package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.PeoplePostRepository;
import com.example.personnelmanager.entity.*;
import com.example.personnelmanager.entity.commonEntity.CustomPage;
import com.example.personnelmanager.service.JobTransferInformationService;
import com.example.personnelmanager.service.PeoplePostService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeoplePostServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/21
 **/


@Service
public class PeoplePostServiceImpl implements PeoplePostService {

    final PeoplePostRepository peoplePostRepository;

    final JobTransferInformationService jobTransferInformationService;

    public PeoplePostServiceImpl(PeoplePostRepository peoplePostRepository, JobTransferInformationService jobTransferInformationService) {
        this.peoplePostRepository = peoplePostRepository;
        this.jobTransferInformationService = jobTransferInformationService;
    }

    @Override
    public PeoplePost addEntity(PeoplePost peoplePost) {
        Page list = getPage(peoplePost, new CustomPage().getPageable());
        if (list.getContent().size()>0){
            throw new GlobalException("该人员已经在该岗位上");
        }
        return peoplePostRepository.save(peoplePost);
    }

    @Override
    public Page getPage(PeoplePost peoplePost, Pageable pageable) {
        Specification<PeoplePost> specification = specificationBuild(peoplePost);
        return (Page<PeoplePost>) peoplePostRepository.findAll(specification, pageable);
    }

    @Override
    public List<PeoplePost> getList(PeoplePost peoplePost) {
        Specification<PeoplePost> specification = specificationBuild(peoplePost);
        return peoplePostRepository.findAll(specification);
    }

    @Override
    public PeoplePost update(PeoplePost peoplePost) {
        return peoplePostRepository.save(peoplePost);
    }

    @Override
    public PeoplePost getOne(Long id) {
        Optional<PeoplePost> byId = peoplePostRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的人员不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        try {
            peoplePostRepository.deleteById(id);
        }catch (Exception e){
            return false;
        }
        return true;
    }

    @Override
    public Specification<PeoplePost> specificationBuild(PeoplePost peoplePost) {
        PredicateBuilder<PeoplePost> and = Specifications.and();
        and.eq("people",peoplePost.getPeople().getPeopleId());
        and.eq("post",peoplePost.getPost());
        return and.build();
    }

}
