package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.UserRepository;
import com.example.personnelmanager.entity.User;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.entity.WorkPlace;
import com.example.personnelmanager.service.UserServer;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class UserServerImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/14
 **/
@Service
public class UserServerImpl implements UserServer {

    @Autowired
    UserRepository userRepository;

    @Autowired
    PasswordEncoder passwordEncoder;

    @Override
    public User addEntity(User user) {
        user.setPassword(passwordEncoder.encode(user.getPassword()));
        User addUser = userRepository.save(user);
        return addUser;
    }

    @Override
    public Page getPage(User user, Pageable pageable) {
        Specification<User> specification = specificationBuild(user);
        return userRepository.findAll(specification, pageable);
    }

    @Override
    public List<User> getList(User user) {
        Specification<User> specification = specificationBuild(user);
        return userRepository.findAll(specification);
    }

    @Override
    public User update(User user) {
        User after = userRepository.save(user);
        return after;
    }

    @Override
    public User getOne(Long id) {
        Optional<User> byId = userRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的工作地点不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<User> byId = userRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        User user = byId.get();
        user.setDeleteTag(1);
        userRepository.save(user);
        return true;
    }

    @Override
    public UserDetail selectByUserName(String username) {
        if (username!=null){
            User byUsername = userRepository.findByUsername(username);
            if (byUsername==null){
                return null;
            }
            UserDetail userDetail = new UserDetail();
            BeanUtils.copyProperties(byUsername,userDetail);
            if (userDetail.getDeleteTag()==1){
                return null;
            }
            return  userDetail;
        }
        return null;
    }

    @Override
    public Specification<User> specificationBuild(User user){
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        PredicateBuilder<User> and = Specifications.and();
        if (user!=null){
            if (!StringUtils.isEmpty(user.getUsername())){
                and.like("username","%"+user.getUsername()+"%");
            }
            if (!StringUtils.isEmpty(user.getPhone())){
                and.like("phone","%"+user.getPhone()+"%");
            }
        }
        and.eq("enterprise", userDetails.getEnterprise());
        and.eq("deleteTag", 0);
        return and.build();
    }


}
