package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.common.utils.DateCalculationUtil;
import com.example.personnelmanager.dao.WorkExperienceRepository;
import com.example.personnelmanager.entity.People;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.entity.WorkExperience;
import com.example.personnelmanager.entity.WorkPlace;
import com.example.personnelmanager.service.PeopleService;
import com.example.personnelmanager.service.WorkExperienceService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class WorkExperienceServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/27
 **/

@Service
public class WorkExperienceServiceImpl implements WorkExperienceService {

    @Autowired
    WorkExperienceRepository workExperienceRepository;

    @Autowired
    PeopleService peopleService;

    @Override
    @Transactional
    public WorkExperience addEntity(WorkExperience workExperience) {
        WorkExperience save = workExperienceRepository.save(workExperience);
        People one = peopleService.getOne(workExperience.getPeople().getPeopleId());
        one.setHistoryWorkingAge(one.getHistoryWorkingAge()+(DateCalculationUtil.twoTimeYearCalculation(workExperience.getWorkStartTime(), workExperience.getWorkEndTime())));
        return save;
    }

    @Override
    public Page getPage(WorkExperience workExperience, Pageable pageable) {
        Specification<WorkExperience> specification = specificationBuild(workExperience);
        return workExperienceRepository.findAll(specification, pageable);
    }

    @Override
    public List<WorkExperience> getList(WorkExperience workExperience) {
        Specification<WorkExperience> specification = specificationBuild(workExperience);
        return workExperienceRepository.findAll(specification);
    }


    @Override
    @Transactional
    public WorkExperience update(WorkExperience workExperience) {
        WorkExperience oldWorkExperience = getOne(workExperience.getWorkExperienceId());
        if (workExperience.getWorkStartTime()!=null||workExperience.getWorkEndTime()!=null){
            double oldHistoryWorkAge = 0.0;
            double newHistoryWorkAge = 0.0;
            if (workExperience.getWorkStartTime()!=null&&workExperience.getWorkEndTime()!=null){
                oldHistoryWorkAge = DateCalculationUtil.twoTimeYearCalculation(oldWorkExperience.getWorkStartTime(), oldWorkExperience.getWorkEndTime());
                newHistoryWorkAge = DateCalculationUtil.twoTimeYearCalculation(workExperience.getWorkStartTime(), workExperience.getWorkEndTime());
            }else if (workExperience.getWorkStartTime()!=null&&workExperience.getWorkEndTime()==null){
                oldHistoryWorkAge = DateCalculationUtil.twoTimeYearCalculation(oldWorkExperience.getWorkStartTime(), oldWorkExperience.getWorkEndTime());
                newHistoryWorkAge = DateCalculationUtil.twoTimeYearCalculation(workExperience.getWorkStartTime(), oldWorkExperience.getWorkEndTime());
            }else if (workExperience.getWorkStartTime()==null&&workExperience.getWorkEndTime()!=null){
                oldHistoryWorkAge = DateCalculationUtil.twoTimeYearCalculation(oldWorkExperience.getWorkStartTime(), oldWorkExperience.getWorkEndTime());
                newHistoryWorkAge = DateCalculationUtil.twoTimeYearCalculation(oldWorkExperience.getWorkStartTime(), workExperience.getWorkEndTime());
            }
            People one = peopleService.getOne(oldWorkExperience.getPeople().getPeopleId());
            one.setHistoryWorkingAge(one.getHistoryWorkingAge()+newHistoryWorkAge-oldHistoryWorkAge);
            peopleService.update(one);
        }
        return workExperienceRepository.save(workExperience);
    }

    @Override
    public WorkExperience getOne(Long id) {
        Optional<WorkExperience> byId = workExperienceRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的工作经历信息不存在");
        }
        return byId.get();
    }

    @Override
    @Transactional
    public Boolean delete(Long id) {
        Optional<WorkExperience> byId = workExperienceRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        WorkExperience workExperience = byId.get();
        workExperience.setDeleteTag(1);
        workExperienceRepository.save(workExperience);
        People one = peopleService.getOne(workExperience.getPeople().getPeopleId());
        one.setHistoryWorkingAge(one.getHistoryWorkingAge()-(DateCalculationUtil.twoTimeYearCalculation(workExperience.getWorkStartTime(), workExperience.getWorkEndTime())));
        return true;
    }

    @Override
    public Specification<WorkExperience> specificationBuild(WorkExperience workExperience){
        PredicateBuilder<WorkExperience> and = Specifications.and();
        and.eq("people",workExperience.getPeople());
        and.eq("deleteTag", 0);
        return and.build();
    }
}
