package com.example.personnelmanager;

import com.example.personnelmanager.common.utils.DateCenterUtil;
import com.example.personnelmanager.common.utils.SpringUtils;
import com.example.personnelmanager.dao.SimpleJpaRepositoryImpl;
import gnu.io.CommPortIdentifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewFilter;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * springBoot启动类
 * 
 * @author Huangxiahao
 */
@EnableAsync
@EnableScheduling
@SpringBootApplication
@EnableSwagger2
@EnableJpaAuditing
@EnableJpaRepositories(repositoryBaseClass = SimpleJpaRepositoryImpl.class)
@ServletComponentScan
public class PersonnelmanagerApplication extends SpringBootServletInitializer {


    public static void main(String[] args) {
        SpringApplication.run(PersonnelmanagerApplication.class, args);
        //todo  初始化一个初始企业  初始化一个admin  初始化一个节点
        System.out.println("程序运行成功");
//        DateCenterUtil dateCenterUtil = SpringUtils.getBean("dateCenterUtil");
//        dateCenterUtil.sendDateToCenter();
//        dateCenterUtil.initUser();
    }

    @Bean
    public OpenEntityManagerInViewFilter openEntityManagerInViewFilter() {
        return new OpenEntityManagerInViewFilter();
    }

}
