package com.example.personnelmanager.common.utils;

import com.example.personnelmanager.entity.OrganizationNode;
import com.example.personnelmanager.entity.People;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DateCenterJsonUtil
 * @packageName com.example.personnelmanager.common.utils
 **/
@Component
public class DateCenterJsonUtil {

    /**
     * 将List<people>生成Json字符串
     * Json结构
     * {
     *   "tableId": 1308221225377472514,
     *   "primaryKeyName": "people_id",
     *   "data": [
     *     {
     *       "primaryKeyValue": 1,
     *       "dataMap": {
     *         "name": "黄某",
     *         "age": "24",
     *         "birthday":"2020-08-17 13:48:21",
     *         "delete_tag": 0 ,
     *         "id_card_number":"3333333333333333",
     *         "post_id":"39",
     *         "node_id":"11",
     *         "icon":"124.70.194.194:13245/images/009bc8c1-fc4a-46a5-a7c0-23b67e26a631.jpg"
     *       }
     *     }
     *   ]
     * }
     * @param allPeople
     * @return
     */
    public String initAllPeopleJsonStr(List<People> allPeople){
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tableId",1346658905505366017L);
        jsonObject.addProperty("primaryKeyName","people_id");
        JsonArray jsonElements = new JsonArray();
        allPeople.forEach(people -> {
            JsonObject jsonElementPeople = new JsonObject();
            jsonElementPeople.addProperty("primaryKeyValue", people.getPeopleId());
            JsonObject jsonElementPeopleData = new JsonObject();
            jsonElementPeopleData.addProperty("name", people.getName());
            jsonElementPeopleData.addProperty("age", people.getAge());
            if (people.getBirthday()!=null){
                jsonElementPeopleData.addProperty("birthday", DateFormatUtil.DEFAULT_ON_SECOND_FORMAT.format(people.getBirthday().toEpochMilli()));
            }
            if (people.getIdCardNumber()!=null){
                jsonElementPeopleData.addProperty("id_card_number", people.getIdCardNumber());
            }
            if (people.getPeoplePosts()!=null&&people.getPeoplePosts().size()>0){
                jsonElementPeopleData.addProperty("post_id", people.getPeoplePosts().get(0).getPost().getPostId());
                jsonElementPeopleData.addProperty("node_id", people.getPeoplePosts().get(0).getPost().getOrganizationNode().getNodeId());
            }
            if (people.getSex()!=null){
                jsonElementPeopleData.addProperty("sex", people.getSex());
            }
            if (people.getPhone()!=null){
                jsonElementPeopleData.addProperty("phone", people.getPhone());
            }
            if (people.getCurrentResidence()!=null){
                jsonElementPeopleData.addProperty("current_residence", people.getCurrentResidence());
            }

            jsonElementPeopleData.addProperty("delete_tag", people.getDeleteTag());
            jsonElementPeopleData.addProperty("icon",people.getIcon());
            jsonElementPeople.add("dataMap",jsonElementPeopleData);
            jsonElements.add(jsonElementPeople);
        });
        jsonObject.add("data",jsonElements);
        return jsonObject.toString();
    }

    /**
     * 将List<OrganizationNode>生成Json字符串
     * Json结构
     * {
     *   "tableId": 1308221225377472514,
     *   "primaryKeyName": "people_id",
     *   "data": [
     *     {
     *       "primaryKeyValue": 1,
     *       "dataMap": {
     *         "node_id":1
     *         "name": "开发部",
     *         "parent_node": "1",
     *         "delete_tag":"0",
     *       }
     *     }
     *   ]
     * }
     * @param allNode
     * @return
     */
   public String initAllOrganizationNodeJsonStr(List<OrganizationNode> allNode){
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tableId",1346658965509079041L);
        jsonObject.addProperty("primaryKeyName","node_id");
        JsonArray jsonElements = new JsonArray();
        allNode.forEach(node -> {
            JsonObject jsonElementPeople = new JsonObject();
            jsonElementPeople.addProperty("primaryKeyValue",node.getNodeId());
            JsonObject jsonElementPeopleData = new JsonObject();
            jsonElementPeopleData.addProperty("node_name",node.getNodeName());
            jsonElementPeopleData.addProperty("parent_node",node.getParentNode());
            jsonElementPeopleData.addProperty("delete_tag",node.getDeleteTag());
            jsonElementPeople.add("dataMap",jsonElementPeopleData);
            jsonElements.add(jsonElementPeople);
        });
        jsonObject.add("data",jsonElements);
        return jsonObject.toString();
    }

    /**
     * People 生成Json字符串 向数据中心提交数据
     * Json结构
     * {
     *   "tableId": 1308221225377472514,
     *   "primaryKeyName": "people_id",
     *   "data": [
     *     {
     *       "primaryKeyValue": 1,
     *       "dataMap": {
     *         "node_id":1
     *         "name": "开发部",
     *         "parent_node": "1",
     *         "delete_tag":"0",
     *       }
     *     }
     *   ]
     * }
     * @param peoples
     * @return
     */
    public String initUserJsonStr(List<People> peoples){
        JsonArray jsonArray = new JsonArray();
        peoples.forEach(people -> {
            JsonObject jsonObject = new JsonObject();
            if (people.getIdCardNumber()!=null){
                jsonObject.addProperty("idCard",people.getIdCardNumber());
            }
            if (people.getSex()!=null){
                if (people.getSex().equals("男")){
                    jsonObject.addProperty("sex",0);
                }else {
                    jsonObject.addProperty("sex",1);
                }
            }
            jsonObject.addProperty("des",people.getName());
            jsonObject.addProperty("name",people.getName());
            jsonObject.addProperty("phone",people.getPhone());
            jsonObject.addProperty("username",people.getName());
            jsonArray.add(jsonObject);
        });

        return jsonArray.toString();
    }
}
