package com.example.personnelmanager.common.utils;

import sun.misc.BASE64Decoder;

import java.io.*;
import java.nio.file.Files;
import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

/**
 * @author bystander
 * @date 2018/9/30
 */
public class RsaUtils {

    /**
     * 从文件中读取公钥
     *
     * @param fileName
     * @return
     * @throws Exception
     */
    public static PublicKey getPublicKey(String fileName) throws Exception {
        String publicKey = readFile(fileName);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey.getBytes()));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePublic(spec);
    }

//    /**
//     * 从文件中读取私钥
//     *
//     * @param fileName
//     * @return
//     * @throws Exception
//     */
//    public static PrivateKey getPrivateKey(String fileName) throws Exception {
//        byte[] bytes = readFile(fileName);
//        return getPrivateKey(bytes);
//    }


    /**
     * 生成私钥
     *
     * @param bytes
     * @return
     * @throws Exception
     */
    public static PrivateKey getPrivateKey(byte[] bytes) throws Exception {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePrivate(spec);
    }

    /**
     * 读取文件
     *
     * @param fileName
     * @return
     * @throws IOException
     */
    public static String readFile(String fileName) throws Exception {
//        return Files.readAllBytes(new File(fileName).toPath());
        BufferedReader reader = new BufferedReader(new FileReader(new File(fileName)));
        String line;
        StringBuffer buffer = new StringBuffer("");
        while ((line=reader.readLine())!=null){
            buffer.append(line);
        }
        reader.close();
        return buffer.toString();

    }



    /**
     * 向目标路径写入文件
     *
     * @param destPath
     * @param bytes
     * @throws IOException
     */
    public static void writeFile(String destPath, byte[] bytes) throws IOException {
        File dest = new File(destPath);
        if (!dest.exists()) {
            boolean newFile = dest.createNewFile();
            if (!newFile){
                throw new IOException("新建文件失败");
            }
        }
        Files.write(dest.toPath(), bytes);
    }
}
