package com.example.personnelmanager.common.utils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * @program: bserver-parent
 * @description: TaskExecutePool,
 *  @EnableAsync：开启异步处理
 * @author: LiuJie
 * @create: 2019-05-20 16:01
 **/
@Configuration
public class TaskExecutePool {

    @Bean
    public ExecutorService executorService() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        return executorService;
    }
}