package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.common.utils.HttpClientUtil;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.entity.User;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.entity.commonEntity.ResultObj;
import com.example.personnelmanager.service.UserServer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class UserController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/14
 **/
@RestController
@RequestMapping("/api/user")
public class UserController {

    @Autowired
    UserServer userServer;

    @Autowired
    HttpClientUtil httpClientUtil;

    @Value("${center.serve}")
    String centerServe;

    @RequestMapping(method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj addUser(@Validated(GroupSave.class) @RequestBody User user) {
        User addUser = userServer.addEntity(user);
        return new ResultObj(addUser, addUser != null ? "success" : "插入失败，出现未知的失败原因");
    }

    @RequestMapping(value = "getCurrentUser", method = RequestMethod.GET)
    public ResultObj getCurrentUser() {
        UserDetail authentication = AuthenticationUtils.getAuthentication();
        User user = new User();
        user.setName(authentication.getName());
        user.setUsername(authentication.getUsername());
        return new ResultObj(user, "查询成功");
    }

    @RequestMapping(value = "/sendTask", method = RequestMethod.POST)
    public ResultObj sendTask() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("appId", "35");
        jsonObject.addProperty("des", "请用户完善系统中人员信息");
        jsonObject.addProperty("link", "http://192.168.100.246:8080/personnel");
        jsonObject.addProperty("title", "请用户完善人员信息");
        jsonObject.addProperty("userId", "1");
        String post = httpClientUtil.post(centerServe + "/task/add", jsonObject.toString(), "utf-8");
        if (post != null) {
            return new ResultObj(post, "插入任务成功");
        } else {
            throw new GlobalException("插入任务失败，出现未知的失败原因");
        }
    }

    @RequestMapping(value = "/updateTaskSatus", method = RequestMethod.POST)
    public ResultObj updateTaskSatus() {
        JsonObject param = new JsonObject();
        param.addProperty("appId", "35");
        param.addProperty("title", "请用户完善人员信息");
        param.addProperty("userId", "1");
        param.addProperty("status", "1");
        String post = httpClientUtil.post(centerServe + "/task/findByCondition", param.toString(), "utf-8");
        if (!StringUtils.isEmpty(post)) {
            JsonObject jsonObject = new JsonParser().parse(post).getAsJsonObject();
            JsonArray jsonElements = jsonObject.getAsJsonArray("data");
            for (JsonElement je :
                    jsonElements) {
                JsonObject jo = je.getAsJsonObject();
                httpClientUtil.delete(centerServe + "/task/update/status/" + jo.get("id").getAsString() + "/3", null, "utf-8");
            }
            return new ResultObj(post, "删除任务成功");
        } else {
            throw new GlobalException("删除任务失败，出现未知的失败原因");
        }
    }


}
