package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.BecomeRegularWorkerRepository;
import com.example.personnelmanager.entity.BecomeRegularWorkerInformation;
import com.example.personnelmanager.service.BecomeRegularWorkerService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class BecomeRegularWorkerServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/29
 **/
@Service
public class BecomeRegularWorkerServiceImpl implements BecomeRegularWorkerService {

    @Autowired
    BecomeRegularWorkerRepository becomeRegularWorkerRepository;

    @Override
    public BecomeRegularWorkerInformation addEntity(BecomeRegularWorkerInformation becomeRegularWorkerInformation) {
        return becomeRegularWorkerRepository.save(becomeRegularWorkerInformation);
    }

    @Override
    public Page<BecomeRegularWorkerInformation> getPage(BecomeRegularWorkerInformation becomeRegularWorkerInformation, Pageable pageable) {
        Specification<BecomeRegularWorkerInformation> specification = specificationBuild(becomeRegularWorkerInformation);
        return becomeRegularWorkerRepository.findAll(specification, pageable);
    }

    @Override
    public List<BecomeRegularWorkerInformation> getList(BecomeRegularWorkerInformation becomeRegularWorkerInformation) {
        Specification<BecomeRegularWorkerInformation> specification = specificationBuild(becomeRegularWorkerInformation);
        return becomeRegularWorkerRepository.findAll(specification);
    }

    @Override
    public BecomeRegularWorkerInformation update(BecomeRegularWorkerInformation becomeRegularWorkerInformation) {
        return becomeRegularWorkerRepository.save(becomeRegularWorkerInformation);
    }

    @Override
    public BecomeRegularWorkerInformation getOne(Long id) {
        Optional<BecomeRegularWorkerInformation> byId = becomeRegularWorkerRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的转正记录不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<BecomeRegularWorkerInformation> byId = becomeRegularWorkerRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的转正记录记录");
        }
        BecomeRegularWorkerInformation becomeRegularWorkerInformation = byId.get();
        becomeRegularWorkerInformation.setDeleteTag(1);
        becomeRegularWorkerRepository.save(becomeRegularWorkerInformation);
        return true;
    }

    @Override
    public Specification<BecomeRegularWorkerInformation> specificationBuild(BecomeRegularWorkerInformation becomeRegularWorkerInformation) {
        PredicateBuilder and = Specifications.and();
        if (becomeRegularWorkerInformation!=null){
            if (becomeRegularWorkerInformation.getPeople().getPeopleId()!=null){
                and.eq("people.peopleId",becomeRegularWorkerInformation.getPeople().getPeopleId());
            }
        }
        and.eq("deleteTag", 0);
        return and.build();
    }
}
