package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.CertificateRepository;
import com.example.personnelmanager.entity.Certificate;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.service.CertificateService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class CertificateServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/18
 **/

@Service
public class CertificateServiceImpl implements CertificateService {

    @Autowired
    CertificateRepository certificateRepository;

    @Override
    public Certificate addEntity(Certificate certificate) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        certificate.setEnterprise(userDetails.getEnterprise());
        Certificate save = certificateRepository.save(certificate);
        return save;
    }

    @Override
    public Page getPage(Certificate certificate, Pageable pageable) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        PredicateBuilder and = Specifications.<Certificate>and();
        and.eq("people.peopleId",certificate.getPeople().getPeopleId());
        and.eq("enterprise", userDetails.getEnterprise());
        and.eq("deleteTag", 0);
        Specification<Certificate> specification = and.build();
        Page<Certificate> all = certificateRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public List<Certificate> getList(Certificate certificate) {
        return null;
    }

    @Override
    public Certificate update(Certificate certificate) {
        Certificate after = certificateRepository.save(certificate);
        return after;
    }

    @Override
    public Certificate getOne(Long id) {
        Optional<Certificate> byId = certificateRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的合同不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<Certificate> byId = certificateRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的合同");
        }
        Certificate certificate = byId.get();
        certificate.setDeleteTag(1);
        certificateRepository.save(certificate);
        return true;
    }

    @Override
    public Specification<Certificate> specificationBuild(Certificate certificate) {
        return null;
    }

}
