package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.UrgentRepository;
import com.example.personnelmanager.entity.*;
import com.example.personnelmanager.service.UrgentService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class UrgentServiceImpl implements UrgentService {

    @Autowired
    UrgentRepository urgentRepository;

    @Override
    public Urgent addEntity(Urgent urgent) {
        Urgent save = urgentRepository.save(urgent);
        return save;
    }

    @Override
    public Page getPage(Urgent urgent, Pageable pageable) {
        Specification<Urgent> specification = specificationBuild(urgent);
        return (Page<Title>) urgentRepository.findAll(specification, pageable);
    }

    @Override
    public List<Urgent> getList(Urgent urgent) {
        Specification<Urgent> specification = specificationBuild(urgent);
        return urgentRepository.findAll(specification);
    }

    @Override
    public Urgent update(Urgent urgent) {
        Urgent after = urgentRepository.save(urgent);
        return after;
    }

    @Override
    public Urgent getOne(Long id) {
        Optional<Urgent> byId = urgentRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的紧急联系人信息不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<Urgent> byId = urgentRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        Urgent urgent = byId.get();
        urgent.setDeleteTag(1);
        urgentRepository.save(urgent);
        return true;
    }

    @Override
    public Specification<Urgent> specificationBuild(Urgent urgent){
        PredicateBuilder and = Specifications.and();
        and.eq("people",urgent.getPeople());
        and.eq("deleteTag", 0);
        return  and.build();
    }

}
