package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.WorkPlaceRepository;
import com.example.personnelmanager.entity.WorkPlace;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.service.WorkPlaceService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class LegalEntityService
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/13
 **/
@Service
public class WorkPlaceServiceImpl implements WorkPlaceService {

    @Autowired
    WorkPlaceRepository workPlaceRepository;

    @Override
    public WorkPlace addEntity(WorkPlace workPlace) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        workPlace.setEnterprise(userDetails.getEnterprise());
        return workPlaceRepository.save(workPlace);
    }

    @Override
    public Page<WorkPlace> getPage(WorkPlace workPlace, Pageable pageable) {
        Specification<WorkPlace> specification = specificationBuild(workPlace);
        return (Page<WorkPlace>) workPlaceRepository.findAll(specification, pageable);
    }

    @Override
    public List<WorkPlace> getList(WorkPlace workPlace) {
        Specification<WorkPlace> specification = specificationBuild(workPlace);
        return (List<WorkPlace>) workPlaceRepository.findAll(specification);
    }

    @Override
    public WorkPlace update(WorkPlace workPlace) {
        return workPlaceRepository.save(workPlace);
    }

    @Override
    public WorkPlace getOne(Long id) {
        Optional<WorkPlace> byId = workPlaceRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的工作地点不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<WorkPlace> byId = workPlaceRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        WorkPlace workPlace = byId.get();
        workPlace.setDeleteTag(1);
        workPlaceRepository.save(workPlace);
        return true;
    }

    @Override
    public Specification<WorkPlace> specificationBuild(WorkPlace workPlace){
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        PredicateBuilder<WorkPlace> and = Specifications.and();
        if (workPlace!=null){
            if (!StringUtils.isEmpty(workPlace.getWorkPlaceName())){
                and.like("workPlaceName","%"+workPlace.getWorkPlaceName()+"%");
            }
            if (!StringUtils.isEmpty(workPlace.getWorkPlaceArea())){
                and.like("workPlaceArea","%"+workPlace.getWorkPlaceArea()+"%");
            }
            if (!StringUtils.isEmpty(workPlace.getWorkPlaceType())){
                and.like("workPlaceType","%"+workPlace.getWorkPlaceType()+"%");
            }
        }
        and.eq("enterprise", userDetails.getEnterprise());
        and.eq("deleteTag", 0);
        return and.build();
    }
}
