package com.example.personnelmanager.common.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class BeanConfig
 * @packageName com.example.demo.common.config
 * @data 2020/4/21
 **/

@Configuration
public class BeanConfig {

    @Bean
    public Validator validator(){
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        return validatorFactory.getValidator();
    };

    @Bean
    public Authentication authentication(){
        return SecurityContextHolder.getContext().getAuthentication();
    }

}
