package com.example.personnelmanager.common.exception;


import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.fasterxml.jackson.core.JsonParseException;
import org.hibernate.JDBCException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.io.IOException;
import java.util.HashMap;

/**
 * 描述：错误处理类
 * 所有的报错信息都会通过本层的方法向外界返回
 *
 * @author HuangXiahao
 * @version V1.0
 * @class ErrorController
 * @packageName com.example.demo.controller
 * @description
 * @data 2020/4/7
 **/
@ControllerAdvice
public class GlobalExceptionHandler {

    /**
     * 描述：所有的报错信息都会通过这个方法处理并通过统一的返回方式进行返回
     *
     * @param e  报错信息
     * @Return : com.example.demo.entity.ResultObj
     * @Author : HuangXiahao
     * @Date : 2020/4/10 15:14
    */
    @ResponseBody
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(Exception.class)
    public ResultObj errorMessage(Exception e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),e.getMessage());
        return resultObj;
    }

    @ResponseBody
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(BindException.class)
    public ResultObj errorMessage(BindException e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),e.getAllErrors().get(0).getDefaultMessage());
        return resultObj;
    }

    @ResponseBody
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(MethodArgumentNotValidException.class)
    public ResultObj errorMessage(MethodArgumentNotValidException e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),e.getBindingResult().getAllErrors().get(0).getDefaultMessage());
        return resultObj;
    }

    @ResponseBody
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(JDBCException.class)
    public ResultObj errorMessage(JDBCException e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),"关键参数未填写");
        return resultObj;
    }

    @ResponseBody
    @ResponseStatus(code = HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(AuthenticationException.class)
    public ResultObj errorMessage(AuthenticationException e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),e.getMessage());
        return resultObj;
    }

    @ResponseBody
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(HttpMessageNotReadableException.class)
    public ResultObj errorMessage(HttpMessageNotReadableException e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),"上传内容格式不正确");
        return resultObj;
    }

    @ResponseBody
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(HttpMessageConversionException.class)
    public ResultObj errorMessage(HttpMessageConversionException e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),"上传内容格式不正确");
        return resultObj;
    }

    @ResponseBody
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(IOException.class)
    public ResultObj errorMessage(IOException e){
        ResultObj resultObj = new ResultObj(new HashMap<>(),"文件上传失败");
        return resultObj;
    }
}
