package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupSaveImage;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.Certificate;
import com.example.personnelmanager.entity.CertificateImage;
import com.example.personnelmanager.entity.commnEntity.ResultObj;

import com.example.personnelmanager.entity.vo.CertificatePageableVo;
import com.example.personnelmanager.service.CertificateImageService;
import com.example.personnelmanager.service.CertificateService;
import com.example.personnelmanager.service.ContractImageService;
import com.example.personnelmanager.service.ContractService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ClassUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.UUID;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class CertificateController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/18
 **/
@RestController
@RequestMapping("/api/certificate")
public class CertificateController {

    @Autowired
    CertificateService certificateService;

    @Autowired
    CertificateImageService certificateImageService;

    @RequestMapping(method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<Certificate> addContract(@Validated(GroupSave.class) @RequestBody Certificate certificate) {
        Certificate addCertificate = certificateService.addEntity(certificate);
        ResultObj<Certificate> resultObj = new ResultObj(addCertificate, addCertificate != null ? "success" : "插入失败，出现未知的失败原因");
        return resultObj;
    }

    @RequestMapping(value = "/list", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getContractPage(@RequestBody CertificatePageableVo certificatePageableVo) {
        return new ResultObj(certificateService.getList(certificatePageableVo.getCertificate(), certificatePageableVo.getPageable()), "success");
    }

    @RequestMapping(method = RequestMethod.DELETE, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj delContract(@Validated(GroupDelete.class) @RequestBody Certificate certificate) {
        return new ResultObj(certificateService.delete(certificate.getCertificateId()), "success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getContract(@Validated(GroupDelete.class) Certificate certificate) {
        return new ResultObj(certificateService.getOne(certificate.getCertificateId()), "success");
    }

    @RequestMapping(method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateContract(@Validated(GroupUpdate.class) @RequestBody Certificate certificate) {
        return new ResultObj(certificateService.update(certificate), "success");
    }

    @RequestMapping(value = "/file",method = RequestMethod.POST)
    public CertificateImage addContractImage(@RequestParam("file") MultipartFile file, @Validated(GroupSaveImage.class) Long certificateId) throws IOException {
        if (!file.isEmpty()) {
            CertificateImage certificateImage = new CertificateImage();
            //获取文件名
            String fileName = file.getOriginalFilename();
            //获取文件后缀
            String suffixName = fileName.substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            //指定本地存入路径
            String path = ClassUtils.getDefaultClassLoader().getResource("static/images/").getPath();
            file.transferTo(new File(path + fileName));
            Certificate certificate = new Certificate();
            certificate.setCertificateId(certificateId);
            certificateImage.setCertificate(certificate);
            certificateImage.setUrl("/images/" + fileName);
            certificateImageService.addEntity(certificateImage);
        } else {
            throw new GlobalException("文件是空的");
        }
        return null;
    }

}
