package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupSaveImage;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.Contract;
import com.example.personnelmanager.entity.ContractImage;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.entity.vo.ContractPageableVo;
import com.example.personnelmanager.service.ContractImageService;
import com.example.personnelmanager.service.ContractService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ClassUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.UUID;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class ContractController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/15
 **/
@RestController
@RequestMapping("/api/contract")
public class ContractController {

    @Autowired
    ContractService contractService;

    @Autowired
    ContractImageService contractImageService;

    @RequestMapping(method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<Contract> addContract(@Validated(GroupSave.class) @RequestBody Contract contract) {
        Contract addContract = contractService.addEntity(contract);
        ResultObj<Contract> resultObj = new ResultObj(addContract, addContract != null ? "success" : "插入失败，出现未知的失败原因");
        return resultObj;
    }

    @RequestMapping(value = "/list", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getContractPage(@RequestBody ContractPageableVo contractVo) {
        return new ResultObj(contractService.getList(contractVo.getContract(), contractVo.getPageable()), "success");
    }

    @RequestMapping(method = RequestMethod.DELETE, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj delContract(@Validated(GroupDelete.class) @RequestBody Contract contract) {
        return new ResultObj(contractService.delete(contract.getContractId()), "success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getContract(@Validated(GroupDelete.class) Contract contract) {
        return new ResultObj(contractService.getOne(contract.getContractId()), "success");
    }

    @RequestMapping(method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateContract(@Validated(GroupUpdate.class) @RequestBody Contract contract) {
        return new ResultObj(contractService.update(contract), "success");
    }

    @RequestMapping(value = "/file",method = RequestMethod.POST)
    public ContractImage addContractImage(@RequestParam("file") MultipartFile file,@Validated(GroupSaveImage.class) Long contractId) throws IOException {
        if (!file.isEmpty()) {
            ContractImage contractImage = new ContractImage();
            //获取文件名
            String fileName = file.getOriginalFilename();
            //获取文件后缀
            String suffixName = fileName.substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            //指定本地存入路径
            String path = ClassUtils.getDefaultClassLoader().getResource("static/images/").getPath();
            file.transferTo(new File(path + fileName));
            Contract contract = new Contract();
            contract.setContractId(contractId);
            contractImage.setContract(contract);
            contractImage.setUrl("/images/" + fileName);
            contractImageService.addEntity(contractImage);
        } else {
            throw new GlobalException("文件是空的");
        }
        return null;
    }

}
