package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.LegalEntity;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.entity.vo.LegalEntityPageableVo;
import com.example.personnelmanager.service.LegalEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class LegalEntity
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/13
 **/

@RestController
@RequestMapping("/api/legalEntity")
public class LegalEntityController {

    @Autowired
    LegalEntityService legalEntityService;

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<LegalEntity> addLegalEntity(@Validated(GroupSave.class) @RequestBody LegalEntity legalEntity){
        LegalEntity addLegal = legalEntityService.addEntity(legalEntity);
        ResultObj<LegalEntity> resultObj = new ResultObj(addLegal,addLegal!=null?"success":"插入失败，出现未知的失败原因");
        return resultObj;
    }

    @RequestMapping(value = "/list",produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getLegalEntityPage(@RequestBody LegalEntityPageableVo legalEntityPageableVo){
        return new ResultObj(legalEntityService.getList(legalEntityPageableVo.getLegalEntity(), legalEntityPageableVo.getPageable()),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj delLegalEntity(@Validated(GroupDelete.class) @RequestBody LegalEntity legalEntity){
        return new ResultObj(legalEntityService.delete(legalEntity.getLegalEntityId()),"success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getLegalEntity(@Validated(GroupDelete.class) LegalEntity legalEntity){
        return new ResultObj(legalEntityService.getOne(legalEntity.getLegalEntityId()),"success");
    }

    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateLegalEntity(@Validated(GroupUpdate.class) @RequestBody LegalEntity legalEntity){
        return new ResultObj(legalEntityService.update(legalEntity),"success");
    }
}
