package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.People;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.entity.vo.PeoplePageableVo;
import com.example.personnelmanager.service.PeopleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeopleController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/15
 **/
@RestController
@RequestMapping("/api/people")
public class PeopleController {

    @Autowired
    PeopleService peopleService;

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<People> addPeople(@Validated(GroupSave.class) @RequestBody People people){
        People addPeople = peopleService.addEntity(people);
        ResultObj<People> resultObj = new ResultObj(addPeople,addPeople!=null?"success":"插入失败，出现未知的失败原因");
        return resultObj;
    }

    @RequestMapping(value = "/list",produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getPeoplePage(@RequestBody PeoplePageableVo peoplePageableVo){
        return new ResultObj(peopleService.getList(peoplePageableVo.getPeople(), peoplePageableVo.getPageable()),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj delPeople(@Validated(GroupDelete.class) @RequestBody People people){
        return new ResultObj(peopleService.delete(people.getPeopleId()),"success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getPeople(@Validated(GroupDelete.class) People people){
        return new ResultObj(peopleService.getOne(people.getPeopleId()),"success");
    }

    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updatePeople(@Validated(GroupUpdate.class) @RequestBody People people){
        return new ResultObj(peopleService.update(people),"success");
    }


}
