package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.Post;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.entity.vo.PostPageableVo;
import com.example.personnelmanager.service.PostService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PostController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/19
 **/
@RestController
@RequestMapping("/api/post")
public class PostController {

    @Autowired
    PostService postService;

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<Post> addPost(@Validated(GroupSave.class) @RequestBody Post post){
        Post addPost = postService.addEntity(post);
        ResultObj<Post> resultObj = new ResultObj(addPost,addPost!=null?"success":"插入失败，出现未知的失败原因");
        return resultObj;
    }

    @RequestMapping(value = "/list",produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getPostPage(@RequestBody PostPageableVo postPageableVo){
        return new ResultObj(postService.getList(postPageableVo.getPost(),postPageableVo.getPageable()),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj delPost(@Validated(GroupDelete.class) @RequestBody Post post){
        return new ResultObj(postService.delete(post.getPostId()),"success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getPost(@Validated(GroupDelete.class) Post post){
        return new ResultObj(postService.getOne(post.getPostId()),"success");
    }

    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updatePost(@Validated(GroupUpdate.class) @RequestBody Post post){
        return new ResultObj(postService.update(post),"success");
    }


}
