package com.example.personnelmanager.dao;

import com.example.personnelmanager.entity.OrganizationNode;
import com.example.personnelmanager.entity.vo.OrganizationNodeListVo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface OrganizationNodeRepository extends JpaRepository<OrganizationNode, Long>, JpaSpecificationExecutor {

    @Query("select new com.example.personnelmanager.entity.vo.OrganizationNodeListVo(m.nodeId,m.nodeName,m.parentNode,m.nodeType) " +
            "FROM OrganizationNode m  where m.enterprise.enterpriseId=:enterpriseId and m.deleteTag = 0")
    List<OrganizationNodeListVo> findTreeNode(Long enterpriseId);

    @Modifying
    @Query("update OrganizationNode o set o.deleteTag = 1 where o.nodeId=:nodeId or o.nodeLevel like concat('%.',:nodeId,'.%') ")
    void deleteorganizationNode(Long nodeId);

}
