package com.example.personnelmanager.dao;

import com.example.personnelmanager.entity.Post;
import com.example.personnelmanager.entity.vo.PostVo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class LegalEntityDao
 * @packageName com.example.personnelmanager.dao
 * @data 2020/5/13
 **/
public interface PostRepository extends JpaRepository<Post, Long>, JpaSpecificationExecutor {

    @Query("select new com.example.personnelmanager.entity.vo.PostVo(p.postId,p.postName,p.postIntroduction,p.organizationNode.nodeId) from " +
            "Post p where p.enterprise.enterpriseId =:enterpriseId and p.deleteTag=0")
    List<PostVo> findPostListVoByEnterpriseId(Long enterpriseId);

    @Modifying
    @Query("update Post o set o.deleteTag = 1 where o.organizationNode.nodeId=:nodeId or o.nodeLevel like concat('%.',:nodeId,'.%') ")
    void deletePostByNodeId(Long nodeId);
}
